/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.manager;

import filenet.vw.apps.manager.VWNodeInformation;
import filenet.vw.apps.manager.images.VWImageLoader;
import filenet.vw.base.VWDebug;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.SystemColor;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class VWTreeCellRenderer
extends DefaultTreeCellRenderer {
    private Icon m_workflowIcon = null;
    private Icon m_closedFolderIcon = null;
    private Icon m_openFolderIcon = null;
    private Icon m_userQueueIcon = null;
    private Icon m_workQueueIcon = null;
    private Icon m_MilestonesFolderIcon = null;

    public VWTreeCellRenderer() {
        this.loadIcons();
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DefaultMutableTreeNode node = null;
        VWNodeInformation nodeInfo = null;
        node = (DefaultMutableTreeNode)value;
        if (node == null) {
            return null;
        }
        nodeInfo = (VWNodeInformation)node.getUserObject();
        if (nodeInfo == null) {
            return null;
        }
        this.setText(nodeInfo.getName());
        if (node.isRoot()) {
            this.setIcon(this.m_workflowIcon);
        } else {
            switch (nodeInfo.getType()) {
                case 1: {
                    if (selected) {
                        this.setIcon(this.m_openFolderIcon);
                        break;
                    }
                    this.setIcon(this.m_closedFolderIcon);
                    break;
                }
                case 2: {
                    this.setIcon(this.m_userQueueIcon);
                    break;
                }
                case 3: {
                    this.setIcon(this.m_workQueueIcon);
                    break;
                }
                case 4: {
                    this.setIcon(this.m_MilestonesFolderIcon);
                }
            }
        }
        this.setFont(tree.getFont());
        if (selected) {
            this.setBackground(SystemColor.textHighlight);
            this.setForeground(SystemColor.textHighlightText);
        } else {
            this.setBackground(tree.getBackground());
            this.setForeground(tree.getForeground());
        }
        return this;
    }

    public void paint(Graphics g) {
        int textStart = 0;
        int textWidth = 0;
        Icon icon = this.getIcon();
        if (this.getComponentOrientation().isLeftToRight()) {
            textWidth = this.getSize().width - textStart;
            if (icon != null) {
                textStart = this.getIcon().getIconWidth() + this.getIconTextGap();
                this.getIcon().paintIcon(this, g, 0, 0);
            }
        } else {
            textStart = 0;
            if (icon != null) {
                textWidth = this.getSize().width - this.getIcon().getIconWidth() - this.getIconTextGap();
                this.getIcon().paintIcon(this, g, textWidth, 0);
            }
        }
        g.setColor(this.getBackground());
        g.fillRect(textStart, 0, textWidth, this.getSize().height);
        g.setColor(this.getForeground());
        g.drawString(this.getText(), textStart, g.getFontMetrics().getAscent());
    }

    private boolean loadIcons() {
        try {
            this.m_workflowIcon = VWImageLoader.createImageIcon("workflow.gif");
            this.m_openFolderIcon = VWImageLoader.createImageIcon("openfolder.gif");
            this.m_closedFolderIcon = VWImageLoader.createImageIcon("closedfolder.gif");
            this.m_userQueueIcon = VWImageLoader.createImageIcon("q_user_16.gif");
            this.m_workQueueIcon = VWImageLoader.createImageIcon("q_work_16.gif");
            this.m_MilestonesFolderIcon = VWImageLoader.createImageIcon("milestonetracking_16.gif");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return false;
        }
        return true;
    }
}

